(defun keygen-geotools-22 (
      / GeoToolsPath GeoToolsVersion GeoToolsLanguage LicenseMethod 
        OperatingPlatform SerialNumber ApplicationKey UserName CompanyName 
        Address1 Address2 Address3 City State Country ZIPCode Telephone Fax 
        Email LicenseType NumberOfUsers OrderNumber OrderDate ExpireAfter
        StartDate ExpiryDate DelayTime HowSold AppKeyType SteelWorksLicense
        SerialNumber ApplicationKey OperatingPlatform2 LicFileName
        GUIDCheck FloatingLicenseDialog FloatingLicensePath LicenseFor 
        ACCM_Comments CLIENT_Comments Geological_License
        AllowedLicenseModules LicensedModules
        Railway_License Transmission_License
        #GEOTOOLSKEYLST7 #GEOTOOLSKEYLST8 #GEOTOOLSKEYLST8_DE
        #GEOTOOLSKEYLST8_ES #GEOTOOLSKEYLST9 #GEOTOOLSKEYLST9_DE 
        #GEOTOOLSKEYLST9_ES #GEOTOOLSKEYLST10 #GEOTOOLSKEYLST10_DE 
        #GEOTOOLSKEYLST10_ES #GEOTOOLSKEYLST10_RU #GEOTOOLSKEYLST11 
        #GEOTOOLSKEYLST11_DE #GEOTOOLSKEYLST11_ES #GEOTOOLSKEYLST11_RU 
        #GEOTOOLSKEYLST12 #GEOTOOLSKEYLST12_DE #GEOTOOLSKEYLST12_ES 
        #GEOTOOLSKEYLST12_RU #GEOTOOLSKEYLST13 #GEOTOOLSKEYLST13_DE 
        #GEOTOOLSKEYLST13_ES #GEOTOOLSKEYLST14 #GEOTOOLSKEYLST14_DE
        #GEOTOOLSKEYLST14_ES #GEOTOOLSKEYLST15 #GEOTOOLSKEYLST15_DE
        #GEOTOOLSKEYLST15_ES #GEOTOOLSKEYLST15_PTB #GEOTOOLSKEYLST16
        #GEOTOOLSKEYLST16_DE #GEOTOOLSKEYLST16_ES #GEOTOOLSKEYLST16_PTB
        #GEOTOOLSKEYLST17 #GEOTOOLSKEYLST17_DE #GEOTOOLSKEYLST17_ES
        #GEOTOOLSKEYLST17_PTB #GEOTOOLSKEYLST18 #GEOTOOLSKEYLST18_DE
        #GEOTOOLSKEYLST18_ES #GEOTOOLSKEYLST18_PTB #GEOTOOLSKEYLST19
        #GEOTOOLSKEYLST19_DE #GEOTOOLSKEYLST19_ES #GEOTOOLSKEYLST19_PTB
        #GEOTOOLSKEYLST20 #GEOTOOLSKEYLST20_DE #GEOTOOLSKEYLST20_ES
        #GEOTOOLSKEYLST20_PTB #GEOTOOLSKEYLST21 #GEOTOOLSKEYLST21_DE
        #GEOTOOLSKEYLST21_ES #GEOTOOLSKEYLST21_PTB #GEOTOOLSKEYLST22
        #GEOTOOLSKEYLST22_DE #GEOTOOLSKEYLST22_ES #GEOTOOLSKEYLST22_PTB
        #TRANSFERKEYLST 
        LicFilePath GeoToolsPath FID
        )
        
  ;; ===========================================================================
  ;; User Data - Edit according to your preferences
  ;; ===========================================================================
  
  ;; GeoTools installation folder.
  (setq GeoToolsPath            "C:\\Program Files\\Designsense\\GeoTools22_EN")
  
  ;; GeoTools version for licensing.
  ;; Acceptable values: 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22
  (setq GeoToolsVersion         "22")
  
  ;; Language. Acceptable values: 
  ;; - for version 7: EN
  ;; - for version 10, 11, 12: EN, DE, ES, RU
  ;; - for version 8, 9, 13, 14: EN, DE, ES
  ;; - for version 15, 16, 17, 18, 19, 20, 21, 22: EN, DE, ES, PTB
  (setq GeoToolsLanguage        "EN")

  ;; License type:
  ;; - "Portable"/any other value - for version 12 or less.
  ;; - "AppKeys-On-Computer", "SerialNumber-On-Computer", "AppKeys-Internet", 
  ;;   "SerialNumber-Internet", "Floating-On-Computer", "Floating-Internet" -
  ;;   for version 13.
  ;;    "AppKeys-On-Computer" - licence based on application key;
  ;;    "SerialNumber-On-Computer" - license based on AutoCAD serial number;
  ;;    other options not checked.
  (setq LicenseMethod           "SerialNumber-On-Computer")

  ;; Floating license path. Not checked, better not modify.
  (setq FloatingLicensePath     "")
  
  ;; Platform. Acceptable values: "AutoCAD"/"BricsCAD".
  (setq OperatingPlatform       "AutoCAD")

  ;; AutoCAD serial number (Help -> About).
  (setq SerialNumber            "000-00000000")

  ;; Application key generated by GeoTools.
  ;; GeoTools -> Display Application Key...
  (setq ApplicationKey          "000-000-000-000-000-000-000-000")

  ;; Data displayed in license info.
  ;; Fill in anything you like.
  (setq 
    UserName                "LAVteam member"
    CompanyName             "::LAVteam::" 
    Address1                "http://lavteam.net/"
    Address2                ""
    Address3                ""
    City                    ""
    State                   ""
    Country                 "UK"
    ZIPCode                 ""
    Telephone               ""
    Fax                     ""
    Email                   ""
    LicenseType             "Free"
    NumberOfUsers           "1"
    OrderNumber             ""
    OrderDate               "01.01.1900"
    LicenseFor              ""
    ACCM_Comments           ""
    CLIENT_Comments         ""
  )

  ;; ===========================================================================
  ;; Don't edit the code beyond this line!
  ;; ===========================================================================

  (setq
    ExpireAfter             ""
    StartDate               "01.01.2015"
    ExpiryDate              "01.01.2030"
    DelayTime               ""
    HowSold                 "AppKeys"
    AppKeyType              "Disk"
    SteelWorksLicense       "Yes"
    Geological_License      "Yes"
    GUIDCheck               "No"
    FloatingLicenseDialog   "No"
    AllowedLicenseModules   "All"
    LicensedModules         "All"
    Railway_License         "Yes"
    Transmission_License    "Yes"
  )
  (if (/= SerialNumber "")
    (setq SerialNumber (strcat SerialNumber "," UserName))
  )
  (if (/= ApplicationKey "")
    (setq ApplicationKey (strcat ApplicationKey "," UserName))
  )  
  
  (setq #GEOTOOLSKEYLST7 (LIST "32qwtrewrTDFFCHGcgcVJ;l'l[P][-]=0--09-09]-0][P][p][P[0opOPMJniubhiubUGvf6R65453243145" "r87Y0P,pI[-0]-[p;][P/;.mi,KmniUYB786t6554324s31s2sx54e6769B8UP09[-=\]P.[PL.OmjNhubyV" "6TvFC564deXC5433XWS432Q12AXSCDVF76BnM,o,[OP,]p.]p908uunh987y87y87Y87BGVF45W432w432w45" "3E2q54R87Y09Io][P][[].;][P.;.]pl[,OLPMOIJNMOIJniuhiyhbuyGVYTRE6542431q43SXZSzx5evb8n" "hy98Ui0]p]'[;L;]PPL0ol-0,IK09imj9NJOUHBUT65DE542W4314QSXS5c6v7B8Nmjp,ol.;['][.[,"))
  (setq #GEOTOOLSKEYLST8 (LIST "fl;'j'[ki=o0-79t6361hajhgftDfHJIZYDEEKFKFO56PPAkjy78aO0EK3KDOC[P][G]J=N0TRKI4JDHAYY5" "VGMKGHLYLRFKKDKjxue83krlgvg;;h.bn/daLO0psd04io3klwekdk9E93UTRK2LOlJDKIOG4KL;G;[PB[TY/" "HJ=6G9049SklE83GJKRLG;PB0Y90Y84JSDSJkksdhjse728sjsma,xlznc,kg-t09cf9066l3kl1wjzkKH0E9Y" ",.B=-JKI0852ISKZLAQJSHksdoru8gjkerhopr0484ghieyvgfueuitjkvgkfkKIkiuIFKJKF9RBKKLle93920" "58674829fkxmvi89t60pskAS;C/V'HYK=[K]T=-DF9SJI2KSHXVZX7SA67ydi3jdc8iodrvg03kmkgrvfkihr" "9vuelgkvovo ktOoc0CFK3IODFOIVJRKHLGF90DIkfkl;rg;p0botlnr87Y0P,pI[-0]-[p;][P/;.mi,Kmni" "UYB786t6554324s31s2sx54e6769B8UP09[-=\]P.[PL.OmjNhuby450968fijow34iurydfasdg235r1739V" "dpogk958i3985u9u098AU908USR0892U490E8FU0a89u0awe895u3098u098uU898U908U07Y98y978y08u09-"))
  (setq #GEOTOOLSKEYLST8_DE (LIST "flx'j'[ki=o0-7xt6361xajhgftDhHJIZYDEjKFKFO5ePPAkjys8aO0EKkKDOC[cf[G]s=NwTRcIbgDnAYY5" "VfMsGHLYLRFKxDKjxxs83krlgvg;;h.bwefaLO0psd04io3klwekdkdE9mUTvK2LqlJrKIOj4KL;s;[PB[fY/" "Hg=6G9049SklEg3GJKRLG;gB0Y90Y8sJSDSJkesdhjsl728sjsmb,xlzncxkg-tq9cf90r6l3klswjzkgH0E9Y" ",sB=-JKd0852ISvZLAzJSHk1doru8gj8er5opr248aghijyvgfieuitjtvgkskKIkiuIFKsKF9eBKKLle939h0" "28w7x829bkgmvi89t60pskA6;C/V'HYK=6K]T=-3F9SsI2KSgXVZXSSA67ydi3jdQ8iodrvg03kDkgrvfkCD" "9vusadkvovo ktOoceCFKsdODFOIVJRKHLGFhfDIkfkl;rg;p0bo;lnr87Y0P,pI[;0]-[p;][P/;.mp,Kmni" "UYaa86t6554324sD1s2sx54e67DDB8UP09[-=\]P.[Pj.jmjNHH450968fijow34Hhydfabdg235r67h9V" "dSSgSS58i3985u9u0SSAU908USR0892SS90E8FU0SS9u0awe895u3098uSD8uU898U908SS7Y98y978y08Q09-"))
  (setq #GEOTOOLSKEYLST8_ES (LIST "fl;DD'[ki=o0-79t63YYhajhgftDf88IZYDEE22KFO56PPAkjy78aJ0EK3KDOC[P][G]JDSDTRKI4SSHAYY5" "VGfKGHLYLdFKKDKjxfe83krlrvg;;h.bn/daLOupsdffio3klwekdk9E93UTRK2LaaJDKIOG4KhhG;[PB[TYs" "QJ=6G9049SkdE83GJKRLG;hj0Y90Y94JSDSJkk6dhjse7;8sjs[a,xl]nc,kg;t09c.9066lvkl1w,zkKH0E9Y" ",.B=-JKI0852ISKZLAQJSHksdoru8gjkerhopr0484ghieyvgfueuitjkvgkfkKIkiuIFKJKF9RBKKLleb3920" "58674829fkxmvi89t60pskAS;C/V'HYK=[K]T=-DF9SJI2KSHXVZX7SA67ydi3jdc8iodrvg03kmkgrvfkihr" "9v1112k2ovo ktO7c0CFK3IODFOI3JRKHLGF90DI3fkl;rg;p0bot4nr87Y0P,p6[-0]-[f;][P/;.mi,Kmni" "UDD786t6554324s31sGGx54e6769B8UP0Bn-=m]P.[PL.OmsNhubySS0968f@@ow34iury^^asdg235r^^39V" "dpogk9!8i3985u9u098AU9%8USR0892U490E8FU0a@@u0awe895u3098u##8uU898U908U07Y98y978y0**09-"))
  (setq #GEOTOOLSKEYLST9 (LIST "kvklf9e85ujkghogh8gdksjdkHjiUIXJ4UGFKKkKIDU7849WKIj89KIjf894ifjfu859okiJFU9IERKFJFIDF" "JVIE8D6WEHJdf88wjifk5rlgf-v-fr[v[][][V';TLR.C/C,CMIioiod84ufjklbvl;g''b/y=509fu4jfkd" "jfjke8d5c2s13TRXTG2HQBGZBCMBH.LM/L'O=H=0-iodki3jf7ubv7ty4hy4iot9bn8m-j=j['vld,jyhidjk" "GF8RK30S78CTSHjkdjhwd441289r=ulp[l'[yll;LDFKG,CV,XBNXVVY750okfl5ph-j'k']9o,l[u;tlo0" "G9FRO4KLG;KOkmjemv,h..//o'p]9-60827614a4EFASGDBHZVCBEJF789ov-ph;p78lk-=-,p[il;k[pjl;h" "YDH2JTK90J=89=0''K.,ldjkvhubdfnmkwid0f=7yuy-9488HJSH1GABXNCFS56F8BGOJL;I.K/,]=lkdjgtr" "UD7380H-I;./;MK/NB=A-oklsjwhysbdu6g6e78rjgkopnm-y=n'';FKIF727UAHZXM,GHPN[P;U';,[=-M-V" "jd839ophl.i;k=j\i]'h;;LF,KJXBFU8GH6E524STnjxkrlbl;.j/[l=[k-ui;ioht7rfghhjHSRD5ETYHFJF" "BJUFKLOG089B889js736f80b0-6lnlphy0bn90rkIU8D7GF76WEU4KHY09NIO6KKKIiidjuv849t0klbn0696y"))
  (setq #GEOTOOLSKEYLST9_DE (LIST "vkig9t4oeo7W5626SDHNF,BOPY=J=J[UJKY][PL;KCFIJWEL;KH[IOP8YUYTUYG35W3SZXtycfugi9y09u" "IOUHFOIPFK[P=G;B';;L,LLuhyugre32erzxCY980-9[-O0LOkojionuibVTCTD45e45e7fr87HY09J-0k[po" "09iopkoihiy87T56EDV76F8YI9LO];'P-'p='p;.op.lik8y654424rs5d65F76G9H09J-I9-LO=0;=/;;OL.L" "3850Y;HHYJ=]'H/LLOKIkldeiducgei9gf90ty-u[h[;KGFO=-N'[U'H-GORKDFUCVHEJKS6YAtyHGHD5W4127" "GF;G;-HUUIJIO0GFT836QWYUw423fgzxbcfuINMFIHLJBN88ERGUPG=Y;BNOlfnmueke8r6qw45dyIKDODFPFP" "DF939KTPGLPO89u78yytfyuboj[pokl-[=-';[/[l.p,koIHY786T76565D56F765f653w43sd7t6g9hohoiju" "4r89e9kgly0opKW772GDHSHZBCMB,H.J/,'L]=';OJ[-GF;P;oiodf9egk;otghdfre8EKWOKLPR8GF7WWLID" "7wjrkg90hllUFJKLPOJ0TI4KUIQ86ER42TDHDIKIKuifkgo-0jji=]lo;j/.h,[p--L;PO[PY08OW7IYGKUWE" "IJF78DPBHLYKLY0-ODFP9UUIOyu5yr65iuopp0d==g'.r.sek8dyugUGTS4535WTRH;K8OPYPOJPOP9ILUGF"))
  (setq #GEOTOOLSKEYLST9_ES (LIST "g9t94icf6ywjdfkbg9odg949kisj987W5617UYAGFABXMF,.H;K'OP]" "8EJERMGFKGH0HP5;BH'';klisdy27fik6jopj=-i=\0'o'jp0gt836245qgJDKHLYPMK-;P8;JPkjofuirok" "fh3jkgf9h9pt6l;if7f7yj23log0ul7h9fu8wj289quMKF,.B.M'']P-Y0DF8SHZCssws4w4527rikt0phopu" "dh3jkgy9j0hj;y=y=-	05846we6y2ujst6agJSDVG5DTCNBGKOJLLHLkvhje78y-i=k]j'l;gftjvdhyywdhd" "UDJ23M,KG9JLB,.HKLRDKFHYKkfiohpojl;loo=u=]-0g908gkdeljfrhbgyugYDTUVFIUGOIUY4WEYFOJUFH" "fjkrklh0pypjltir8t69340ul78kr7yuJSH524DTRGHIROHLY0JIEROLHJUHIkjbguwmeohuhykhoptohj-t=o[;" "fjwk8h9otlkoJDY625DXGJGKNOOPUPJ=YU='L'J/,.CVMFHIF8yhdw55wgtduirophl;jj-upot9r8iejue7ue" "djkekigllt9n8dkklHS54W4D7F890G-PHI=L'JL;M90GL;HJLGKIHKFIODUJKhyufielg0y9klt9hutopht" "IDKTMPH=KIO'[K'YUL/G.VFMXBHZGTS312D3A5TUhsd78er9gkt0h0-u89rk3us5xezxgJJNF8RKGIRGUPYP"))
  (setq #GEOTOOLSKEYLST10 (LIST "jjdjhcudyuywhjakjcufiif8c77e73yue9d93i" "kkgiikkklfidfudjwkleldkfjuidjdkfjkvjyd" "kfkdkidiig787w626ysy8c89f948dfi49999yd" "GF8RK30S78CTSHjkdjhwd441289rwerrettrre" "dgdfgyhhtyu7674534512rghtyj76978676u56" "htjyuki78i896y45t523433rwefieugrthrgue" "hjyjk7yuki7ui56y45t45trfsdfsadxcdvgthn" "2897yyhasuhicjmofjg9ug895u4t8934y86y23" "gogjhotuh6958u87y87t564e43w342aw23xsvf"))
  (setq #GEOTOOLSKEYLST10_DE (LIST "gfdxsferwaq234e56487698y9u8juiojkijili" "gfcfdxsdfzwera423q33e65r76t897y0987u90" "jipo9u9878ygtftrde455r7t8y9uouijoijuij" "hjkhhjgopiuop98987ty76t65e54e5r765r76t" "lkjoiuiuyt5r56fr5d4es5365r76t78g87gh87" "loi987u87ty76trfdweswxcxdvf7gt87g6y87y" "ijiouuihuygftrds4rsw54e76t876y897y987h" "lkjiouy78tyygbvyfrdxszesw6r68g7y98uoui" "hjhbhgvfcdt5r87y9uopij;ijkiuhjuygkhgkh"))
  (setq #GEOTOOLSKEYLST10_ES (LIST "gvgfcdzres4EW43E65r76t8gy89yh98hu89hui" "98u87y78t76frdes4w3ade65fr76GF76G78TG8" "JHJBGHVFDRSTRD6r76r76t89hyu9uijOUHIOUH" "JHJOIUOUYUIGYGCFGdresrwes43w45e6RFUTFT" "JOUIIOUYUHYUhuygfdersersrfUYGTUGIUHYIH" "KOJKLHHJGGHFYFYTFTYRFTYFUGiyughiuhiouh" "lkjljoiuiygt65r54e43wxs4x4sfft76t86y7h" "oiopui9o87u87y786t7tg6frdders4w45w35r7" "hhggfddsrs4qw432476876987098708uukjiku"))
  (setq #GEOTOOLSKEYLST10_RU (LIST "fkohyoh98tr73ujwhfy8gtolph0h90botl599f" "vfjdjsdyd648itolhpn908f76sywhyu4r8f9er" "gkigkh87d6d4s56y3uitki9h89ty9o6ykig87j" "fjst6s545s5ui590u0objkdhgddeig7e7e8i3e" "shashyf79toi58fr7r65626yshjkdklfjbirob" "djdjigh7876f7y3hstswtryubiktinuhjufju8" "dhshhahnhmvkihi8fr76t2gthsjuegfhyeujdr" "fkigiihryu7sdtwtasggfqwhdjkgtibigtuirj" "bkhighihjejdhwyxhjejkgiiifrjvfuywehddh"))
  (setq #GEOTOOLSKEYLST11 (LIST "jgkfg98girir5874iurhed7fye98ei37yeue3ii" "kjfio9ed7873uwuyuu8YUYS7EW8EIIiiuudue8w" "ckkfogpof0d8777766YYGR6655R76g87g8ygt8s" "odijfpe9u98u98u98U87Y7675fr54745e65DE7r" "8]7Y8Y897Y87y987y987y987ty987G98GDDYGVw" "VDSFVEDOUO98U98u098u098uuufredtecsrfGwf" "o9jiuhouy87t65r43w54sX54D54ED6FF8H9H8hy" "weaezxzred65d6RF76F76Tf78tg87]yg8utyguy" "p0989887y76tg6rfED4SXWSXDFVBG7bgt8b7wgw"))
  (setq #GEOTOOLSKEYLST11_DE (LIST "kjgkgufifoi9ff8787665r55f4e453ws34xsf8" "b'l;;'/..,kpokkojuhygbg878GTT6FV7f7bg0" "o98u87y67r56rF5RF7G87H9J8H98u9j8u9h97h" "-099j8yu87g6t65r4w34azz34zxs5rf67F768G" "O98U87T6T5F6FR54d564edf65r7GRF76GF87G7" "P9I98Y6T54E3SXXSEAZ4VFYBGUHOIJPKPOK[PO" "FGHGHJNYUIK78U664R232SSDSCFDVBGNJ,KL.L" "0987uhgf5431qdclkmnbgftfRTFYGHOIUHPJHi" "BHJNUJMIKK,OLP0'[OPIOLKUIKJYJHTHTRFGEF"))
  (setq #GEOTOOLSKEYLST11_ES (LIST "jjkkjfuf788fi4ikk3ue7ghsie9fokkjf87vue" "IUHU8Y76TG6FGf7g89h9j09jijmoijoujuihG8" "98873987278YIUDJIJIUhuhuguHIUHOIHUYT6t" "0t-t=f-f[d[eode9e8uwsyyayuuWGyfgytshod" "o98u9u9UJ89UH7G87G8Yh98uj98uj9U8J9H8Y7" "P09I09IK9I09I9i9uj9j09jujuhBYTGRDXCVNh" "';;/.,MMKJUYY6543EDFDFDSAZSDSDSWWErtyh" ";l;;;ppplo0o9887654edfgcxxsdder6tg7877" "rhyokgpopKPOOUUHUYGUBYTGTftyrftfubvubu"))
  (setq #GEOTOOLSKEYLST11_RU (LIST "7gyu7tg68hIUHIJOMIJNK,;..LPLP[KOIJHYGS" "TYHRTOUOUJPKOJOIj8y7gvtgbnhoujoijouhni" "765t7gnh9UJJUMOJOPIJPOIKPoijoijoujomjj" "0p9ipokpoik;;[o,lkomijinuhb7gf5rfc54es" "IUYHIUHiuhiuhiUHIUHYTFtyftrvd4tedTGIOb" "ANJNEYAJOIjoijiohIUHUYGUBYGiuyguyginh8" "POIJIMOJoiujoijOIJOIUJIuhyfvtrcvtrdrew" "];]/;[.p,lp,kpokpOIKMOJOIUJHIUYHYTgtyf" "908u8y87y7t67R65R564e54ed45swa32qasc54"))
  (setq #GEOTOOLSKEYLST12 (LIST "kjhkjsdhvidfhoiefroiejfosidfjoiefjodfjf" "asdiiouiy67654e45dd76t9ujjoojioijhsdcuh" "dsoudoifuowfyjfpodkjdmojdovhjdoifudjofi" "doijdosifjaoewu8we7yh87yewiuhdoasdchojf" "9877865564e4323azs4xcd6rf76t98u0k9iu0ki" "dfkldsofkl.d.polkpo,ipoiaspmake98wue9r8" "wepfiasodu8a7ydwdnhsncdjhcki.vol/.lge-p" "'/;';l.l,;okoeijioaujeiuwheuiyghwiuehfd" "fg;lijsrefpokewpor3oy73t6r8ahf0wejkfseo"))
  (setq #GEOTOOLSKEYLST12_DE (LIST "OP9IOIUI87YU7T6R5DD5SX5DFF6FGTUYGUYGUY" "8908787t6rfytgGggtyfrtd3w32xscFV^Fuygr" "]][[;;;lkkkmnhhHGFtYtrfyyytrffyfdsred" "bghtyjyutytroi949837983u0iek039ie0w9ei" "dfl;sfjohiug6yr45e4554d6gf87hojoijoijj" "pdfu9we8dyw9e8uew9dj9fkregmdkvjpmvjdfo" "noihuhvgyvvftcdxerws432q43%^R^7tfg87gd" "][[p]p[o-090898787y87t6rdrtfrtdESesds" "iuou8yi87t7giuhiUGUGFyd43543w342q34a5d"))
  (setq #GEOTOOLSKEYLST12_ES (LIST "iou8y78fdfdfdfgdfddfgfddfgdhmujkmik78r" "IYIUYUYGuhiuhiuhIUhiuhot65r45decxdbhj8" "OUOJIU*Y8y8yoijoikpok,lo.l;;olpikjoijf" "i876765rf54e4ws432ws54df6%RFG&^tgh87y8" ".';/.[';]-p=-o-o9iujiuhiyhghugufttydrt" "iytu76tr564e5d4eD%$ED5r7g6t8y9hJy9h87y" "lpoi09i98u8yhut6rredsSD5edf6rv6fv7tfuy" ";[l.pk,omjnuhnbuygvtdcrees43w4366t8Y8Y" "/'P[POPIOIJIUHUYGTFRSRE%^d^%6FR65RDGJU"))
  (setq #GEOTOOLSKEYLST12_RU (LIST "p09iuiohiuguygyftftyfYTFTYFyguygiugiud" "nfgnfljdfgjdfofijfoisjflsdkfmsdlfkjsdf" ";joihuigtyftrdfguyhoijojpokpojojuhiuhs" "lijiuyguygbuhijsdojsscjskjcbzxlkcnlzxk" "dclihihuyguaysguyt3r63t8whdwe9deujsomi" "jdpovkjdpoverjpgoufo9weurowjweopdjwepo" "LJojojojidhsiuchGOVINDAeoifheoifuerrew" "ULIYAROGOLIkjhbdfkdjsncdokfbjocjdd;vfv" "12345667890kjjhgfdswerttyjjhfgjdsjsdlk"))
  (setq #GEOTOOLSKEYLST13 (LIST "897yhuhnhb7G^T&G76gb7gh8nhn9mujinuhgioh" "i gytfvytrfR%F^F7t6f7654ed45ed54ed65rfv" "YGBGYHbniyhinuhinnhiy6t675rvfv5frftfhff" "09m9ijnh nug ygb87g8nh8uhonikujoijoujho" "iuhinhniunhiuhniuhiuhn uihniuhnbdysgu4f" "98nye*Y*&+Tg76T*&T*&T*&Y*hnuhiuguyfhiji" "87yn786tv675tB&^GB*&G87bg*N7yh8NHnuh6t7" "76v5r675vrf546f765tb6776gb87^GB&G*7g87g" "9n8y8767tv6756gB&G&BgbnHIBnhyibnhinhjjj"))
  (setq #GEOTOOLSKEYLST13_DE (LIST "876g6556r56f&^%FVB^&GB^gb8n7gybn*&hbn8y" "87b6t675rv^F%VB^FB&^gtbgb76g nbg68g8b7g" "65454343243cdcrdvf76t87y098u0ujnuhyggyg" "98nygtfT^&FV&^FGb7tgB*N&GBN*GYBYGoihoin" "u7v6t67fvgBHIUhiUBNHibnhIBNhbinuhyibbhr" "7b6g65ef54e45DCRDv56frv7^F%v7gbvgbvg87g" "987h87t65rf54d5dc4swescedtfbuygubghuhhj" "p0lkk8nhbygvrdcxxdx43w43e24cdvfvtgyughh" "87hy78y78GHB786gtb7^GB^&gb67gBV^gvb76rd"))
  (setq #GEOTOOLSKEYLST13_ES (LIST "e9ruoidujfomidjfoneijfidmjfiojodffjgoim" "hyniyh7gtbt5e54e543wd34scd6vcdVF&Bgb8gj" "iunhihiuhBUIGYuygiUGBINUgyiugyBNIuygi87" "098-090n8hbuiygbuygbutf57vf5fVB^GFBVgdo" "8ny87b7bvt6F^F6fbgBUygbnuygibnUygbniuyg" "54c543wxc43sc5dVFvbtgfVBUTGBUygbyugibyg" "8ny87bt546r564r%^FV^&%FB^GB*g6bn7gibnhj" "877656rv6rVB&^%Fb76gtb8n&^*BN&Gyb8n78hg" "76654e54cdCV%$DV%^fVB&^%F7b6vf7b6vf76hj"))
  (setq #GEOTOOLSKEYLST14 (LIST "dsgdfgfdgfsdgfdgdfgdg" "dgdfgdfgdfgfsdgdfgdgd" "hiny6675rvfv5frftfhff" "09m9 ygbuhonioijoujho" "iniunhin547754uhidfg0" "bfdhhgjgh678534rwefff" "456yutiu67iyujtyjgewr"))
  (setq #GEOTOOLSKEYLST14_DE (LIST "4ieffwdfdsfsfdsdft4tg" "876yuhshhGBGyfTYfuy6t" "876g7tgYGBUHbkHGBjghj" "987h6rf65rYGGJBHBGjbh" "76vrrtrdvuyGBYGJBHGJj" "^&Ruygbiugybiugybugbo" "65d5efVUBgUGYUBGUiubg"))
  (setq #GEOTOOLSKEYLST14_ES (LIST "765iuynihndfhuvoiuhUG" "hgbhjgBJHGGHGJHGjhBjh" "u ytfuyghnhknHIUH7980" "^%CR^FUgibuhibuhibuhj" "8766rtUGBIUgbiugbhgjj" "76vtfvuygGHBHG5476778" "87gygniuhonhvfFFHhhgj"))
  (setq #GEOTOOLSKEYLST15 (LIST "IUBUIGbhBIJHKJHKHBHKN" "iunyiuhiuhOIUHOIUHNOI" "IUNHOIUHhoihnJNIJJKLf" "76rv68BYGBiubibuhihuh" "7ybiynuhNOIUHNOIHnoiu" "YVRFC6FVUYgbiugybiuhf" "i5ubygbiuhbihIUHNIUHK"))
  (setq #GEOTOOLSKEYLST15_DE (LIST "UBGUYGBIUYGBIUHbhjhjy" "7bgiubHIUBHIBUHbjkjhh" "iuhnHNIUHNOIHnlkjjhnk" "8nyoyoinoiuOINUNOIUNo" "ihiuhnoinhoiuhHHOINHO" "UUYUBGIYIUYyyiuyiyuUU" "VBT876T878y8yuyhiuhhu"))
  (setq #GEOTOOLSKEYLST15_ES (LIST "7y98oiunoiUOIJMOijmoi" "7nbtiuyiunYOIUNYOUN8D" "OIJOIJMIJMJMKJMJKL283" "OIJMOIJnjnjNJNJNLKNJI" "I87YIUYNIUHNOIOINJOII" "BGIUYBIUniunbiuhnoiuH" "I7BIUNIOUnoiunoiuoinh"))
  (setq #GEOTOOLSKEYLST15_PTB (LIST "ywehniuhdonsjdlkjdsff" "87b6tv6cdvrf8nhyoijke" "oijmoiasjdnhsdihjlsjd" "tvcrdc65f8nuhoikjhlig" "inehdiugfbifefggrt435" "oNHIUBYGBygNIUhnihuni" "87bt&BVT8bgBNYhibuhib"))
  (setq #GEOTOOLSKEYLST16 (LIST "8ygniuhNIUhnIUHNIuhnu" "6vrfbnGNuyHNMiuHOMNiu" "6rf&BT8bYGnUHnmiuHMOi" "5c4ed6rfb7gN*ygNIuhni" "7bTGn8ygnIYHniHUnihuo" "5cx4ws6vrdfvbYTFbuGYh" "INGYIHUunnmuhnihuniys"))
  (setq #GEOTOOLSKEYLST16_DE (LIST "654ec43e54365rf76ntgu" "32srvfTFybgnuygNUh9uh" "ibgtbgyhIMHoiUHJomiuj" "54cx365f&B^Tf8bnGYnyd" "5c4ed6vrf7bTb8nygNius" "6vtgmujmIJMOIjmoIJmod" "VBFRTBGIUnhmjnomjomij"))
  (setq #GEOTOOLSKEYLST16_ES (LIST "y98ny7g8yhwN*UHn9uh9i" "iu ygutf876t98hnujkls" "876bv6567gunhmolkmjih" "654ec453s54D^%rf7tGn8" "3xsc543d56rfv&TGBygbn" "54xcde65ftbnYGNIUhNuh" "54scved6vbrfBYTgBYgy8"))
  (setq #GEOTOOLSKEYLST16_PTB (LIST "ywehniuhdonsjdlkjdsff" "87b6tv6cdvrf8nhyoijke" "oijmoiasjdnhsdihjlsjd" "tvcrdc65f8nuhoikjhlig" "inehdiugfbifefggrt435" "oNHIUBYGBygNIUhnihuni" "87bt&BVT8bgBNYhibuhib"))
  (setq #GEOTOOLSKEYLST17 (LIST "7y87yOIUUIJIYTFVUYTHj" "f6tbyuNGUIHNIUhnIUHjk" "^TFUYgnUHNIUHniuHNIHj" "TFTYUNhiuhJKMLKJMLKJJ" "BUYGinhumjhmKMkjmkjmk" "vtfBGFUnkjhNKJHNJNJHJ" "dytfvYTFBGnhjNJhnjnhj"))
  (setq #GEOTOOLSKEYLST17_DE (LIST "iyhniuhNIUHNiuHOIUjkg" "&TiyugINUHNIUHNiuhjkj" "*&YNihnUIHNuihKJHjkhU" "BYGBUYGBunhkkjhnkhjnk" "YGNUHNKhnkjhkjhkjhKJH" "IUNHKnhkjhmkjhmkjhnjk" "KNUHkmjlmkjMKJmlkjmlk"))
  (setq #GEOTOOLSKEYLST17_ES (LIST "876t65rt^&G7H98huojoi" "iuhyniUHIjmlkjmlKjlmk" "uyginUHoJIMLjmlKJmlkl" "i7yniUHNiUHnoUjhmhljk" "5RFTgiyGiuhiuHiuhmjlj" "^&TIyhouIHMOIJMLJKKJJ" "IUNHIUNHJNMKJLjlkmjml"))
  (setq #GEOTOOLSKEYLST17_PTB (LIST "8yu8y7toinhuiuhiuhnlj" "hkjnmlkjhkhbhjvhgcjhd" "987yyutftrdtfygiukkhd" "65cscyfuyghijlkjlkjlk" "u6fvy5d7ugiuhkjhkhkjj" "ouhOIHiuhoijhoijOLjlu" "76t^T87yHyhu8hjoiujoi"))
  (setq #GEOTOOLSKEYLST18 (LIST "gegje9tu8ur9fijepti99" "UHhoiuHoijoihoiuh75r5" "E5r765t*&^T*&^ty87y7i" "$%#E^%r76t87yg8yhhoiu" "$E^%Rf87yguihijhuyg7&" "%^$E$#e7f8y7giuhjhkhg" "$#@W654rtyguyhgkhjkhh"))
  (setq #GEOTOOLSKEYLST18_DE (LIST "t78t^%R&^%R&^Guhuhiou" "R%&^TGYIUHJLHhhy876rw" "&^T87yguhiuhifuyYG&^7" "$#@W^d76fuytgiuygyu88" "%$E&Fyuguhiuyg8tg876t" "%$R&^Tyhoiuhiuhiugyut" "2*U6*&^*^T8tgY^%R^%YY"))
  (setq #GEOTOOLSKEYLST18_ES (LIST "*&^sdfr^etetTYUuhyt4o" "54e6%RTYFG*&6y98hjrkj" "$#E4ghh4h7h6jyuiusgiu" "34ef%R&TFUYGiuygiudgi" "43seDTUFIYGIUYGiuyfiu" "65r654e^RFTYGYIUYGfdI" "98078996098u98070899U"))
  (setq #GEOTOOLSKEYLST18_PTB (LIST "98u98u4^T%765t7y98yu4" "8YT7y7y98t65rv576fguh" "7yujhuytur5f63w645rft" "^%R&^ty*&YOIHYG098y96" "43w647FYgoiuy08098up9"))
  (setq #GEOTOOLSKEYLST19 (LIST "8765867t67T67t76t8766" "tgiguhoiy7t6fyh8y7t64" "RFTGIYUG7Y78Y7R574DE4" "DRESRTfuitiuyoij7y76t" "redRUTYFIytgiyugIYUGU" "5d65r56f76gti7y7yohuu" "76t6t65t*^T867T867t6g"))
  (setq #GEOTOOLSKEYLST19_DE (LIST "7665r6t86tg769t7796t6" "uygiuygiuygouh65ryyyw" "54E546F876Tt76t6t66tt" "74e53654D74e74E747544" "D5454d674FIYGIYUGiuyy" "3e54ERDRfuytfytfi45w4" "edDYRTFutyfitGIUGIUYT"))
  (setq #GEOTOOLSKEYLST19_ES (LIST "585t876T867T6T67t766t" "54e54duF6FR86r5865r86" "786T76T76t7676t876t87" "5ed5RD7futfUTYFITYIYT" "RFUYTFTYFGtgyitFITFIT" "6554E54e754e7E765E755" "5RFRd65ruR6TI6ti76i67"))
  (setq #GEOTOOLSKEYLST19_PTB (LIST "t67tt65r75rr765R6565r" "tf6ti76ti6i76i76tyi87" "54e43ws65dud678697676" "76T76T76T786t76T76T76" "654E5r74r7R75R76R74R5"))
  (setq #GEOTOOLSKEYLST20 (LIST "*UHIYGYTFYGIUY686t672" "^&%R&^tg9YGouihKUGkkj" "Y%$D&^%DiygKUYKUYGKJH" "TRDFUYGVKJHBKjhgyug2i" "&^T^%uhliuhoIHLIUGKJH" "5R*^YGoiugIUGYiuygiuy" "^%R^&%RiuGIUygoIUGUIY"))
  (setq #GEOTOOLSKEYLST20_DE (LIST "7987y978t976T76T976T9" "7g8&G*&y87Ho*UHo87yh7" "i7yh2*&HOUIhOIUhoiuho" "908ua**ygYIgfiuygoiUh" "O*&Y87gYgiuGLKJN>KJHG" "YF%d&^%R*7IUHiuhKIUgu" "UDuyfrDIUgLKUGH*&t*&^"))
  (setq #GEOTOOLSKEYLST20_ES (LIST "87y987YUYguygiugiuyu3" "*&T*&^tiuHgiUGiougIUY" "7YGiuygiuYGIUygkuygiu" "^&%R^&GKUGKJGIUFYIUGU" "IGTGKJHGKJGyg2iog7883" "o8hoigi76iugI&tgi7tgi" "^%R&%RyGIgyiUiuygiugy"))
  (setq #GEOTOOLSKEYLST20_PTB (LIST "I&YIUGURUTGTF2jnlkjb3" "pujpohiugh3iu3hlhn;ln" "iygugo2iuhlwihlskjnk4" "8oy9876r6guftgvkjgkuf" "7tgufutyglgytfgljgkuf"))
  (setq #GEOTOOLSKEYLST21 (LIST "uho8yhi7bgGIUYGUIYHyu" "87ybTGINHiu HIUyhinbu" "B^VVRFt5redC%^dryTfuy" "TCESC%RdfYTfbuyguyiug" "rvcyRYtfuBytgfbuYgtuy" "giu GUygbIUyhgibnHUJg" "BU%R654e$%eD^Tfuytfyu"))
  (setq #GEOTOOLSKEYLST21_DE (LIST "^%R^TGuyguygjuyhgiubj" "*&TYBUYGFUYGBJGJHGFgg" "^$EC%$EDbtufuybgjyhgj" "o8YIYGUR%^r65fgyhjhgh" "%$#SECV$ed765rfutfgtj" "^VEDYtrfuyjgjhgjhg767" "$ED65$ED^%RFTYRfyfyut"))
  (setq #GEOTOOLSKEYLST21_ES (LIST "76t587y98yuhgtrdF^87y" "^%FR%^RFyhgiuhkjhjhgd" "%$ES^%$R76gt87ghnkhjh" "%$EDv6tf87gyinuhkjghh" "$%DVB6tgfinyhujkghrfu" "&B^V%E^V$%5btIGIUYOIU" "#$ECVDYRFU^TGyukgyutu"))
  (setq #GEOTOOLSKEYLST21_PTB (LIST "[*&[*HIUT&^HO]*&YH*]Y" "UGYBG7tg76t6708y09865" "^%RE%CE^%R%F*&T2H*&9j" "rd4w543W$#@QW65r*79*&" "iuygYRDv76FRU&YGiuyhi"))
  (setq #GEOTOOLSKEYLST22 (LIST "76bt86t7bfrv6b5t5gBNI&TG68&BGtin7ygI$N8bgyi7" "GB*&^Tu6VFR%^e4c$E#65FRV&CDE^%VYFBIBYGBUBGY8" "FBUVTRF%^4ef$^SEdfcEDV7yTUFINgyHINhyuiuhyni&" "R&VB^5r%&V^tgfBNIGYniUGHiubGibyuGIUbgIUBgyui" "FV^5RE^%4eF^%4ef^$%ef^%R8bn&T^Gu7b^TUbyvuBvy" "RFBV65rV%&rfV&%4efd&tgNIBgyuIUgyInibiugyiuby" "FBVU^5r^%4rd&%rfg&^BTUgbuybgUygtuybguinyu7uj"))
  (setq #GEOTOOLSKEYLST22_DE (LIST "YNB8T67T^&tgnIUygIUgybIUGYBuygbiUGYByugtb" "NB&^T65vrb%DRb76TGF*&ygtINGYgyugbuibGIUgy" "HN%&b6t&^Vrf%^$EDF6v5d^V%RdfbuGiugyhiubgy" "V^%$e^%$Edvb^#$E6%RB&^bnrfU^&BFuytguygbuy" "FVB%$e%&VBRF76tbgFIYGniugYNIUGYiuGYBINugy" "EV^C%$3e%$#cd4#@%WVF65r4d&F^tbfuGBYiugyui" "^V54e%$3df4%WS#Dc54ed6VRTSA64RFginGUiuNGI"))
  (setq #GEOTOOLSKEYLST22_ES (LIST "Y*N&YU^&tfg&^%RVF76T*Bt67g*&GBUYguybgbh" "TB&^V5r%^VBRF7R%&B^58tgnI&GYINugynIUGYN" "FV%RdTCDRVVYtbfubGuBGYubygUBttuuygtbuyg" "RFV&^5r%^VBFR&B^TgiuBYGIubgYIUBGYibugyu" "&VB^Rf56VFrftbYgbiugyBUIgiUBGiugyuiygug" "GBV^%rf^C%DF657fUBGYiugNIUgybyubiygUgyu" "GBUGFYVvrfUGYNUIGNbiugYGUGYbgBIUGBYYBub"))
  (setq #GEOTOOLSKEYLST22_PTB (LIST "&I*N&YT&*T876tg*&^YGNnib&HYT*&BHT*Y&BGYI*nb" "9n8&YT87bT&^r5gf76VRE^$#5r^*&8yhjoiUHoiuh65" "GFB^VRF56DF&vdC$EDF^&tgINBYGHIUYib7hGYIgpmo" "F BV%RFv5^F&^Ft87G*&YghnYIGHGY*HGYughuibygB" "V^F%R56$EF^%df^FYBGiuHIUHNINHIUhnINBUHyuihy"))

  (setq #TRANSFERKEYLST (LIST ".v,v;;gph0684ik3jdhxnmzzbxvgfg21y628405-08=o=oo']opp]k'j;.n,kfxjsyyweyteueirecwerby]" "jjuusu8e87UUahsyyewwsiisuJJL::>>}}[{Psw0w99282uuwjkske4kieeijujjl;l;;WLEIIWO9uoiu8" "kfkfid9s8a89IAI9D48U8IoASODKKkjisir9r8r84i3jkekdoflt;yj''kk/hf./r.r,dl,lL;;P234xs2ws" "DIR993828JSJDJCJFIDFLG;H;'X'';as;;el;fltpt;t;t;y;y[u[uy]6]5=5-30291817w6ayzh" "fot0604e's'lfuahsyw72uwjkekklrlktkri38w8dufkkajjJSJJFHSHASNnJUIIWIIisii2929ec3r43f"))
  

  (vl-load-com)
  
  (cond
    ((= OperatingPlatform "AutoCAD") (setq OperatingPlatform2 "_AC"))
    ((= OperatingPlatform "BricsCAD") (setq OperatingPlatform2 "_BC"))
  )
  (setq LicFileName (strcat "GeoToolsUser" GeoToolsVersion "_" GeoToolsLanguage OperatingPlatform2 ".rgs"))
  (cond
    ((= GeoToolsVersion "7") (setq #GEOTOOLSKEYLST #GEOTOOLSKEYLST7))
    ((= GeoToolsVersion "8")  
      (cond
        ((= GeoToolsLanguage "EN") (setq #GEOTOOLSKEYLST #GEOTOOLSKEYLST8))
        ((= GeoToolsLanguage "DE") (setq #GEOTOOLSKEYLST #GEOTOOLSKEYLST8_DE))
        ((= GeoToolsLanguage "ES") (setq #GEOTOOLSKEYLST #GEOTOOLSKEYLST8_ES))
      )
    )
    ((= GeoToolsVersion "9")  
      (cond
        ((= GeoToolsLanguage "EN") (setq #GEOTOOLSKEYLST #GEOTOOLSKEYLST9))
        ((= GeoToolsLanguage "DE") (setq #GEOTOOLSKEYLST #GEOTOOLSKEYLST9_DE))
        ((= GeoToolsLanguage "ES") (setq #GEOTOOLSKEYLST #GEOTOOLSKEYLST9_ES))
      )
    )
    ((= GeoToolsVersion "10")  
      (cond
        ((= GeoToolsLanguage "EN") (setq #GEOTOOLSKEYLST #GEOTOOLSKEYLST10))
        ((= GeoToolsLanguage "DE") (setq #GEOTOOLSKEYLST #GEOTOOLSKEYLST10_DE))
        ((= GeoToolsLanguage "ES") (setq #GEOTOOLSKEYLST #GEOTOOLSKEYLST10_ES))
        ((= GeoToolsLanguage "RU") (setq #GEOTOOLSKEYLST #GEOTOOLSKEYLST10_RU))
      )
    )
    ((= GeoToolsVersion "11")  
      (cond
        ((= GeoToolsLanguage "EN") (setq #GEOTOOLSKEYLST #GEOTOOLSKEYLST11))
        ((= GeoToolsLanguage "DE") (setq #GEOTOOLSKEYLST #GEOTOOLSKEYLST11_DE))
        ((= GeoToolsLanguage "ES") (setq #GEOTOOLSKEYLST #GEOTOOLSKEYLST11_ES))
        ((= GeoToolsLanguage "RU") (setq #GEOTOOLSKEYLST #GEOTOOLSKEYLST11_RU))
      )
    )
    ((= GeoToolsVersion "12")  
      (cond
        ((= GeoToolsLanguage "EN") (setq #GEOTOOLSKEYLST #GEOTOOLSKEYLST12))
        ((= GeoToolsLanguage "DE") (setq #GEOTOOLSKEYLST #GEOTOOLSKEYLST12_DE))
        ((= GeoToolsLanguage "ES") (setq #GEOTOOLSKEYLST #GEOTOOLSKEYLST12_ES))
        ((= GeoToolsLanguage "RU") (setq #GEOTOOLSKEYLST #GEOTOOLSKEYLST12_RU))
      )
    )
    ((= GeoToolsVersion "13")  
      (cond
        ((= GeoToolsLanguage "EN") (setq #GEOTOOLSKEYLST #GEOTOOLSKEYLST13))
        ((= GeoToolsLanguage "DE") (setq #GEOTOOLSKEYLST #GEOTOOLSKEYLST13_DE))
        ((= GeoToolsLanguage "ES") (setq #GEOTOOLSKEYLST #GEOTOOLSKEYLST13_ES))
      )
    )
    ((= GeoToolsVersion "14")  
      (cond
        ((= GeoToolsLanguage "EN") (setq #GEOTOOLSKEYLST #GEOTOOLSKEYLST14))
        ((= GeoToolsLanguage "DE") (setq #GEOTOOLSKEYLST #GEOTOOLSKEYLST14_DE))
        ((= GeoToolsLanguage "ES") (setq #GEOTOOLSKEYLST #GEOTOOLSKEYLST14_ES))
      )
    )
    ((= GeoToolsVersion "15")  
      (cond
        ((= GeoToolsLanguage "EN") (setq #GEOTOOLSKEYLST #GEOTOOLSKEYLST15))
        ((= GeoToolsLanguage "DE") (setq #GEOTOOLSKEYLST #GEOTOOLSKEYLST15_DE))
        ((= GeoToolsLanguage "ES") (setq #GEOTOOLSKEYLST #GEOTOOLSKEYLST15_ES))
        ((= GeoToolsLanguage "PTB") (setq #GEOTOOLSKEYLST #GEOTOOLSKEYLST15_PTB))
      )
    )
    ((= GeoToolsVersion "16")  
      (cond
        ((= GeoToolsLanguage "EN") (setq #GEOTOOLSKEYLST #GEOTOOLSKEYLST16))
        ((= GeoToolsLanguage "DE") (setq #GEOTOOLSKEYLST #GEOTOOLSKEYLST16_DE))
        ((= GeoToolsLanguage "ES") (setq #GEOTOOLSKEYLST #GEOTOOLSKEYLST16_ES))
      )
    )
    ((= GeoToolsVersion "17")  
      (cond
        ((= GeoToolsLanguage "EN") (setq #GEOTOOLSKEYLST #GEOTOOLSKEYLST17))
        ((= GeoToolsLanguage "DE") (setq #GEOTOOLSKEYLST #GEOTOOLSKEYLST17_DE))
        ((= GeoToolsLanguage "ES") (setq #GEOTOOLSKEYLST #GEOTOOLSKEYLST17_ES))
        ((= GeoToolsLanguage "PTB") (setq #GEOTOOLSKEYLST #GEOTOOLSKEYLST17_PTB))
      )
    )
    ((= GeoToolsVersion "18")  
      (cond
        ((= GeoToolsLanguage "EN") (setq #GEOTOOLSKEYLST #GEOTOOLSKEYLST18))
        ((= GeoToolsLanguage "DE") (setq #GEOTOOLSKEYLST #GEOTOOLSKEYLST18_DE))
        ((= GeoToolsLanguage "ES") (setq #GEOTOOLSKEYLST #GEOTOOLSKEYLST18_ES))
        ((= GeoToolsLanguage "PTB") (setq #GEOTOOLSKEYLST #GEOTOOLSKEYLST18_PTB))
      )
    )
    ((= GeoToolsVersion "19")  
      (cond
        ((= GeoToolsLanguage "EN") (setq #GEOTOOLSKEYLST #GEOTOOLSKEYLST19))
        ((= GeoToolsLanguage "DE") (setq #GEOTOOLSKEYLST #GEOTOOLSKEYLST19_DE))
        ((= GeoToolsLanguage "ES") (setq #GEOTOOLSKEYLST #GEOTOOLSKEYLST19_ES))
        ((= GeoToolsLanguage "PTB") (setq #GEOTOOLSKEYLST #GEOTOOLSKEYLST19_PTB))
      )
    )
    ((= GeoToolsVersion "20")  
      (cond
        ((= GeoToolsLanguage "EN") (setq #GEOTOOLSKEYLST #GEOTOOLSKEYLST20))
        ((= GeoToolsLanguage "DE") (setq #GEOTOOLSKEYLST #GEOTOOLSKEYLST20_DE))
        ((= GeoToolsLanguage "ES") (setq #GEOTOOLSKEYLST #GEOTOOLSKEYLST20_ES))
        ((= GeoToolsLanguage "PTB") (setq #GEOTOOLSKEYLST #GEOTOOLSKEYLST20_PTB))
      )
    )
    ((= GeoToolsVersion "21")  
      (cond
        ((= GeoToolsLanguage "EN") (setq #GEOTOOLSKEYLST #GEOTOOLSKEYLST21))
        ((= GeoToolsLanguage "DE") (setq #GEOTOOLSKEYLST #GEOTOOLSKEYLST21_DE))
        ((= GeoToolsLanguage "ES") (setq #GEOTOOLSKEYLST #GEOTOOLSKEYLST21_ES))
        ((= GeoToolsLanguage "PTB") (setq #GEOTOOLSKEYLST #GEOTOOLSKEYLST21_PTB))
      )
    )
    ((= GeoToolsVersion "22")  
      (cond
        ((= GeoToolsLanguage "EN") (setq #GEOTOOLSKEYLST #GEOTOOLSKEYLST22))
        ((= GeoToolsLanguage "DE") (setq #GEOTOOLSKEYLST #GEOTOOLSKEYLST22_DE))
        ((= GeoToolsLanguage "ES") (setq #GEOTOOLSKEYLST #GEOTOOLSKEYLST22_ES))
        ((= GeoToolsLanguage "PTB") (setq #GEOTOOLSKEYLST #GEOTOOLSKEYLST22_PTB))
      )
    )
  )
  
  (if (or (not (eq 'exrxsubr (type dos_encrypt))) (not (eq 'exrxsubr (type dos_guidgen))))
    (progn
      (princ "\nError: DOSLib not loaded!\n")
      (exit)
    )
  )
  (setq LicFilePath (strcat GeoToolsPath "\\" LicFileName))
  (vl-file-delete LicFilePath)
  (if (setq FID (open LicFilePath "w"))
    (progn
    )
    (progn
      (princ (strcat "\nError creating file: " LicFilePath "\nCheck if folder exists!\n"))
      (exit)
    )
  )
  (write-line "" FID)
  (write-line "[GeoTools Registration]" FID)
  (write-line (strcat "CompanyName             " CompanyName) FID)
  (write-line (strcat "Address1                " Address1) FID)
  (write-line (strcat "Address2                " Address2) FID)
  (write-line (strcat "Address3                " Address3) FID)
  (write-line (strcat "City                    " City) FID)
  (write-line (strcat "State                   " State) FID)
  (write-line (strcat "Country                 " Country) FID)
  (write-line (strcat "ZIPCode                 " ZIPCode) FID)
  (write-line (strcat "Telephone               " Telephone) FID)
  (write-line (strcat "Fax                     " Fax) FID)
  (write-line (strcat "Email                   " Email) FID)
  (write-line (strcat "ExpireAfter             " ExpireAfter) FID)
  (write-line (strcat "StartDate               " StartDate) FID)
  (write-line (strcat "ExpiryDate              " ExpiryDate) FID)
  (write-line (strcat "LicenseType             " LicenseType) FID)
  (write-line (strcat "NumberOfUsers           " NumberOfUsers) FID)
  (write-line (strcat "SerialNumber            " SerialNumber) FID)
  (write-line (strcat "ApplicationKey          " ApplicationKey) FID)
  (write-line (strcat "DelayTime               " DelayTime) FID)
  (write-line (strcat "HowSold                 " HowSold) FID)
  (write-line (strcat "GUIDCheck               " GUIDCheck) FID)
  (write-line (strcat "FloatingLicenseDialog   " FloatingLicenseDialog) FID)
  (write-line (strcat "OrderNumber             " OrderNumber) FID)
  (write-line (strcat "OrderDate               " OrderDate) FID)
  (write-line (strcat "LicenseMethod           " LicenseMethod) FID)
  (write-line (strcat "OperatingPlatform       " OperatingPlatform) FID)
  (write-line (strcat "LicenseFor              " LicenseFor) FID)
  (write-line (strcat "ACCM_Comments           " ACCM_Comments) FID)
  (write-line (strcat "CLIENT_Comments         " CLIENT_Comments) FID)
  (write-line (strcat "GUID                    " (dos_guidgen)) FID)
  (write-line (strcat "Floating_License_Path   " FloatingLicensePath) FID)
  (write-line (strcat "AppKeyType              " AppKeyType) FID)
  (write-line (strcat "SteelWorksLicense       " SteelWorksLicense) FID)
  (write-line (strcat "Geological_License      " Geological_License) FID)
  (write-line (strcat "AllowedLicenseModules   " AllowedLicenseModules) FID)
  (write-line (strcat "LicensedModules         " LicensedModules) FID)
  (write-line (strcat "Railway_License         " Railway_License) FID)
  (write-line (strcat "Transmission_License    " Transmission_License) FID)
  (close FID)
  
  (if (eq 'exrxsubr (type dos_encrypt))
    (progn
      (setq KEY 0)
      (while (<= KEY (- (length #GEOTOOLSKEYLST) 1))
        (if (not (dos_encrypt LicFilePath (nth KEY (reverse #GEOTOOLSKEYLST))))
          (progn
            (princ "\nError: Can't encrypt license!\n")
            (exit)
          )
        )
        (setq KEY (1+ KEY))
      )
    )
    (progn
      (princ "\nError: DOSLib not loaded, can't encrypt license file!\n")
      (exit)
    )
  )
  (princ (strcat "\nGenerated license file: " LicFilePath))
  (princ)
)
(keygen-geotools-22)